/*
 * Decompiled with CFR 0.152.
 */
package live.thought.thought4j.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import live.thought.thought4j.util.StringParser;

public class CrippledJavaScriptParser {
    private static Keyword[] keywords = new Keyword[]{new Keyword("null", null), new Keyword("true", Boolean.TRUE), new Keyword("false", Boolean.FALSE)};

    private static boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private static boolean isIdStart(char ch) {
        return ch == '_' || ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z';
    }

    private static boolean isId(char ch) {
        return CrippledJavaScriptParser.isDigit(ch) || ch == '_' || ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z';
    }

    private static Object parseJSString(StringParser jsString, char delim) {
        StringBuilder b = new StringBuilder();
        while (!jsString.isEmpty()) {
            char sc = jsString.poll();
            if (sc == '\\') {
                char cc = jsString.poll();
                switch (cc) {
                    case 't': {
                        b.append('\t');
                        break;
                    }
                    case 'r': {
                        b.append('\r');
                        break;
                    }
                    case 'n': {
                        b.append('\n');
                        break;
                    }
                    case 'f': {
                        b.append('\f');
                        break;
                    }
                    case 'b': {
                        b.append('\b');
                        break;
                    }
                    case 'u': {
                        try {
                            char ec = (char)Integer.parseInt(jsString.peek(4), 16);
                            b.append(ec);
                            jsString.forward(4);
                        }
                        catch (NumberFormatException ex) {
                            b.append("\\u");
                        }
                        break;
                    }
                    default: {
                        b.append(cc);
                        break;
                    }
                }
                continue;
            }
            if (sc == delim) break;
            b.append(sc);
        }
        return b.toString();
    }

    private static List<Object> parseJSArray(StringParser jsArray) {
        ArrayList<Object> rv = new ArrayList<Object>();
        jsArray.trim();
        if (jsArray.peek() == ']') {
            jsArray.forward(1);
            return rv;
        }
        while (!jsArray.isEmpty()) {
            rv.add(CrippledJavaScriptParser.parseJSExpr(jsArray));
            jsArray.trim();
            if (jsArray.isEmpty()) continue;
            char ch = jsArray.poll();
            if (ch == ']') {
                return rv;
            }
            if (ch != ',') {
                throw new RuntimeException(jsArray.toString());
            }
            jsArray.trim();
        }
        return rv;
    }

    private static String parseId(StringParser jsId) {
        char ch;
        StringBuilder b = new StringBuilder();
        b.append(jsId.poll());
        while (CrippledJavaScriptParser.isId(ch = jsId.peek())) {
            b.append(ch);
            jsId.forward(1);
        }
        return b.toString();
    }

    private static HashMap<String, Object> parseJSHash(StringParser jsHash) {
        LinkedHashMap<String, Object> rv = new LinkedHashMap<String, Object>();
        jsHash.trim();
        if (jsHash.peek() == '}') {
            jsHash.forward(1);
            return rv;
        }
        while (!jsHash.isEmpty()) {
            Object key = CrippledJavaScriptParser.isIdStart(jsHash.peek()) ? CrippledJavaScriptParser.parseId(jsHash) : CrippledJavaScriptParser.parseJSExpr(jsHash);
            jsHash.trim();
            if (!jsHash.isEmpty()) {
                if (jsHash.peek() != ':') {
                    throw new RuntimeException(jsHash.toString());
                }
            } else {
                throw new IllegalArgumentException();
            }
            jsHash.forward(1);
            jsHash.trim();
            Object value = CrippledJavaScriptParser.parseJSExpr(jsHash);
            jsHash.trim();
            if (!jsHash.isEmpty()) {
                char ch = jsHash.poll();
                if (ch == '}') {
                    rv.put(key.toString(), value);
                    return rv;
                }
                if (ch != ',') {
                    throw new RuntimeException(jsHash.toString());
                }
                jsHash.trim();
            }
            rv.put(key.toString(), value);
        }
        return rv;
    }

    public static Object parseJSExpr(StringParser jsExpr) {
        if (jsExpr.isEmpty()) {
            throw new IllegalArgumentException();
        }
        jsExpr.trim();
        char start = jsExpr.poll();
        if (start == '[') {
            return CrippledJavaScriptParser.parseJSArray(jsExpr);
        }
        if (start == '{') {
            return CrippledJavaScriptParser.parseJSHash(jsExpr);
        }
        if (start == '\'' || start == '\"') {
            return CrippledJavaScriptParser.parseJSString(jsExpr, start);
        }
        if (CrippledJavaScriptParser.isDigit(start) || start == '-' || start == '+') {
            StringBuilder b = new StringBuilder();
            if (start != '+') {
                b.append(start);
            }
            char psc = '\u0000';
            boolean exp = false;
            boolean dot = false;
            while (!jsExpr.isEmpty()) {
                char sc = jsExpr.peek();
                if (!CrippledJavaScriptParser.isDigit(sc)) {
                    if (sc == 'E' || sc == 'e') {
                        if (exp) {
                            throw new NumberFormatException(b.toString() + jsExpr.toString());
                        }
                        exp = true;
                    } else if (sc == '.') {
                        if (dot || exp) {
                            throw new NumberFormatException(b.toString() + jsExpr.toString());
                        }
                        dot = true;
                    } else if (sc != '-' && sc != '+' || psc != 'E' && psc != 'e') break;
                }
                b.append(sc);
                jsExpr.forward(1);
                psc = sc;
            }
            return dot || exp ? (Number)Double.parseDouble(b.toString()) : (Number)Long.parseLong(b.toString());
        }
        for (Keyword keyword : keywords) {
            int keywordlen = keyword.keywordFromSecond.length();
            if (start != keyword.firstChar || !jsExpr.peek(keywordlen).equals(keyword.keywordFromSecond)) continue;
            if (jsExpr.length() == keyword.keywordFromSecond.length()) {
                jsExpr.forward(keyword.keywordFromSecond.length());
                return keyword.value;
            }
            if (!CrippledJavaScriptParser.isId(jsExpr.charAt(keyword.keywordFromSecond.length()))) {
                jsExpr.forward(keyword.keywordFromSecond.length());
                jsExpr.trim();
                return keyword.value;
            }
            throw new IllegalArgumentException(jsExpr.toString());
        }
        if (start == 'n' && jsExpr.peek("ew Date(".length()).equals("ew Date(")) {
            jsExpr.forward("ew Date(".length());
            Number date = (Number)CrippledJavaScriptParser.parseJSExpr(jsExpr);
            jsExpr.trim();
            if (jsExpr.poll() != ')') {
                throw new RuntimeException("Invalid date");
            }
            return new Date(date.longValue());
        }
        throw new UnsupportedOperationException("Unparsable javascript expression: \"" + start + jsExpr + "\"");
    }

    public static Object parseJSExpr(String jsExpr) {
        return CrippledJavaScriptParser.parseJSExpr(new StringParser(jsExpr));
    }

    public static LinkedHashMap<String, Object> parseJSVars(String javascript) {
        try {
            String l;
            BufferedReader r = new BufferedReader(new StringReader(javascript));
            LinkedHashMap<String, Object> rv = new LinkedHashMap<String, Object>();
            while ((l = r.readLine()) != null) {
                int i;
                if ((l = l.trim()).isEmpty() || !l.startsWith("var") || (i = (l = l.substring(3).trim()).indexOf(61)) == -1) continue;
                String varName = l.substring(0, i).trim();
                String expr = l.substring(i + 1).trim();
                if (expr.endsWith(";")) {
                    expr = expr.substring(0, expr.length() - 1).trim();
                }
                rv.put(varName, CrippledJavaScriptParser.parseJSExpr(expr));
            }
            return rv;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static class Keyword {
        public final String keyword;
        public final Object value;
        public final char firstChar;
        public final String keywordFromSecond;

        public Keyword(String keyword, Object value) {
            this.keyword = keyword;
            this.value = value;
            this.firstChar = keyword.charAt(0);
            this.keywordFromSecond = keyword.substring(1);
        }
    }
}

