/*
 * Decompiled with CFR 0.152.
 */
package live.thought.jtminer.data;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import live.thought.jtminer.algo.SHA256d;

public class DataUtils {
    private static SHA256d hasher = new SHA256d();
    private static final char[] BASE64_ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    private static int[] toInt = new int[128];
    public static final String ALPHABET = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz";
    private static final BigInteger ALPHABET_SIZE;

    public static String byteArrayToHexString(byte[] b) {
        StringBuilder sb = new StringBuilder(80);
        for (int i = 0; i < b.length; ++i) {
            sb.append(Integer.toString((b[i] & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    public static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        Object source = null;
        if (len % 2 != 0) {
            source = "0" + s;
            ++len;
        } else {
            source = s;
        }
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(((String)source).charAt(i), 16) << 4) + Character.digit(((String)source).charAt(i + 1), 16));
        }
        return data;
    }

    public static String stringToBase64(String str) {
        byte[] buf = str.getBytes();
        int size = buf.length;
        char[] ar = new char[(size + 2) / 3 * 4];
        int a = 0;
        int i = 0;
        while (i < size) {
            byte b0 = buf[i++];
            byte b1 = i < size ? buf[i++] : (byte)0;
            byte b2 = i < size ? buf[i++] : (byte)0;
            ar[a++] = BASE64_ALPHABET[b0 >> 2 & 0x3F];
            ar[a++] = BASE64_ALPHABET[(b0 << 4 | (b1 & 0xFF) >> 4) & 0x3F];
            ar[a++] = BASE64_ALPHABET[(b1 << 2 | (b2 & 0xFF) >> 6) & 0x3F];
            ar[a++] = BASE64_ALPHABET[b2 & 0x3F];
        }
        switch (size % 3) {
            case 1: {
                ar[--a] = 61;
            }
            case 2: {
                ar[--a] = 61;
            }
        }
        return new String(ar);
    }

    public static void uint32ToByteArrayBE(long val, byte[] out, int offset) {
        out[offset + 0] = (byte)(0xFFL & val >> 24);
        out[offset + 1] = (byte)(0xFFL & val >> 16);
        out[offset + 2] = (byte)(0xFFL & val >> 8);
        out[offset + 3] = (byte)(0xFFL & val >> 0);
    }

    public static void uint32ToByteArrayLE(long val, byte[] out, int offset) {
        out[offset + 0] = (byte)(0xFFL & val >> 0);
        out[offset + 1] = (byte)(0xFFL & val >> 8);
        out[offset + 2] = (byte)(0xFFL & val >> 16);
        out[offset + 3] = (byte)(0xFFL & val >> 24);
    }

    public static byte reverseBitsByte(byte x) {
        int intSize = 8;
        byte y = 0;
        for (int position = intSize - 1; position > 0; --position) {
            y = (byte)(y + ((x & 1) << position));
            x = (byte)(x >> 1);
        }
        return y;
    }

    public static long readUint32(byte[] bytes, int offset) {
        return ((long)bytes[offset++] & 0xFFL) << 0 | ((long)bytes[offset++] & 0xFFL) << 8 | ((long)bytes[offset++] & 0xFFL) << 16 | ((long)bytes[offset] & 0xFFL) << 24;
    }

    public static long readUint32BE(byte[] bytes, int offset) {
        return ((long)bytes[offset + 0] & 0xFFL) << 24 | ((long)bytes[offset + 1] & 0xFFL) << 16 | ((long)bytes[offset + 2] & 0xFFL) << 8 | ((long)bytes[offset + 3] & 0xFFL) << 0;
    }

    public static BigInteger decodeMPI(byte[] mpi) {
        int length = (int)DataUtils.readUint32BE(mpi, 0);
        byte[] buf = new byte[length];
        System.arraycopy(mpi, 4, buf, 0, length);
        return new BigInteger(buf);
    }

    public static BigInteger decodeCompactBits(long compact) {
        int size = (int)(compact >> 24) & 0xFF;
        byte[] bytes = new byte[4 + size];
        bytes[3] = (byte)size;
        if (size >= 1) {
            bytes[4] = (byte)(compact >> 16 & 0xFFL);
        }
        if (size >= 2) {
            bytes[5] = (byte)(compact >> 8 & 0xFFL);
        }
        if (size >= 3) {
            bytes[6] = (byte)(compact >> 0 & 0xFFL);
        }
        return DataUtils.decodeMPI(bytes);
    }

    public static byte[] reverseBytes(byte[] bytes) {
        byte[] buf = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            buf[i] = bytes[bytes.length - 1 - i];
        }
        return buf;
    }

    public static byte[] encodeCompact(long height) {
        byte[] retval = null;
        if (height <= 252L) {
            retval = new byte[]{(byte)(height & 0xFFL)};
        } else if (height < 65535L) {
            retval = new byte[]{-3, (byte)(height & 0xFFL), (byte)(height >> 8 & 0xFFL)};
        } else if (height < -1L) {
            retval = new byte[]{-13, (byte)(height & 0xFFL), (byte)(height >> 8 & 0xFFL), (byte)(height >> 16 & 0xFFL), (byte)(height >> 24 & 0xFFL)};
        }
        return retval;
    }

    public static String bytesToBase58(byte[] data) {
        return DataUtils.rawBytesToBase58(DataUtils.addCheckHash(data));
    }

    static String rawBytesToBase58(byte[] data) {
        StringBuilder sb = new StringBuilder();
        BigInteger num = new BigInteger(1, data);
        while (num.signum() != 0) {
            BigInteger[] quotrem = num.divideAndRemainder(ALPHABET_SIZE);
            sb.append(ALPHABET.charAt(quotrem[1].intValue()));
            num = quotrem[0];
        }
        for (int i = 0; i < data.length && data[i] == 0; ++i) {
            sb.append(ALPHABET.charAt(0));
        }
        return sb.reverse().toString();
    }

    static byte[] addCheckHash(byte[] data) {
        try {
            hasher.update(data);
            byte[] hash = Arrays.copyOf(hasher.doubleDigest(), 4);
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            buf.write(data);
            buf.write(hash);
            return buf.toByteArray();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static byte[] base58ToBytes(String s) {
        byte[] concat = DataUtils.base58ToRawBytes(s);
        byte[] data = Arrays.copyOf(concat, concat.length - 4);
        byte[] hash = Arrays.copyOfRange(concat, concat.length - 4, concat.length);
        hasher.update(data);
        byte[] rehash = Arrays.copyOf(hasher.doubleDigest(), 4);
        if (!Arrays.equals(rehash, hash)) {
            throw new IllegalArgumentException("Checksum mismatch");
        }
        return data;
    }

    protected static byte[] base58ToRawBytes(String s) {
        BigInteger num = BigInteger.ZERO;
        for (int i = 0; i < s.length(); ++i) {
            num = num.multiply(ALPHABET_SIZE);
            int digit = ALPHABET.indexOf(s.charAt(i));
            if (digit == -1) {
                throw new IllegalArgumentException("Invalid character for Base58Check");
            }
            num = num.add(BigInteger.valueOf(digit));
        }
        byte[] b = num.toByteArray();
        if (b[0] == 0) {
            b = Arrays.copyOfRange(b, 1, b.length);
        }
        try {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            for (int i = 0; i < s.length() && s.charAt(i) == ALPHABET.charAt(0); ++i) {
                buf.write(0);
            }
            buf.write(b);
            return buf.toByteArray();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static byte[] addressToScript(String addr) {
        byte[] retval = null;
        byte[] addrbin = DataUtils.base58ToBytes(addr);
        byte addrver = addrbin[0];
        switch (addrver) {
            case -63: 
            case 9: {
                retval = new byte[23];
                retval[0] = -87;
                retval[1] = 20;
                System.arraycopy(addrbin, 1, retval, 2, 20);
                retval[22] = -121;
            }
        }
        retval = new byte[25];
        retval[0] = 118;
        retval[1] = -87;
        retval[2] = 20;
        System.arraycopy(addrbin, 1, retval, 3, 20);
        retval[23] = -120;
        retval[24] = -84;
        return retval;
    }

    static {
        for (int i = 0; i < BASE64_ALPHABET.length; ++i) {
            DataUtils.toInt[DataUtils.BASE64_ALPHABET[i]] = i;
        }
        ALPHABET_SIZE = BigInteger.valueOf(ALPHABET.length());
    }
}

