/*
 * Decompiled with CFR 0.152.
 */
package live.thought.jtminer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import live.thought.jtminer.Notification;
import live.thought.jtminer.Poller;
import live.thought.jtminer.Solver;
import live.thought.jtminer.Work;
import live.thought.jtminer.algo.CuckooSolve;
import live.thought.jtminer.data.BlockImpl;
import live.thought.jtminer.util.Console;
import live.thought.thought4j.ThoughtRPCClient;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class Miner
implements Observer {
    public static final String VERSION = "v0.7-Servcity";
    protected static final Options options = new Options();
    protected static final CommandLineParser gnuParser = new GnuParser();
    private static final String DEFAULT_HOST = "localhost";
    private static final String DEFAULT_PORT = "10617";
    private static final String DEFAULT_USER = "user";
    private static final String DEFAULT_PASS = "password";
    private static final String HOST_PROPERTY = "host";
    private static final String PORT_PROPERTY = "port";
    private static final String USER_PROPERTY = "user";
    private static final String PASS_PROPERTY = "password";
    private static final String THREAD_PROPERTY = "threads";
    private static final String COINBASE_PROPERTY = "coinbase-addr";
    private static final String SCRIPT_PROPERTY = "script";
    private static final String DEBUG_OPTION = "debug";
    private static final String HELP_OPTION = "help";
    private static final String CONFIG_OPTION = "config";
    private static final String VOTING_OPTION = "vote";
    private static final String SCRIPT_OPTION = "script";
    private Poller poller;
    private long lastWorkTime = 0L;
    private long lastWorkCycles = 0L;
    private long lastWorkSolutions = 0L;
    private long lastWorkErrors;
    private AtomicLong cycles = new AtomicLong(0L);
    private AtomicLong errors = new AtomicLong(0L);
    private AtomicLong solutions = new AtomicLong(0L);
    private long attempted = 0L;
    private long accepted = 0L;
    private volatile Work curWork = null;
    private AtomicInteger cycleIndex = new AtomicInteger(0);
    private static Miner instance;
    private static int debugLevel;
    protected String coinbaseAddr;
    protected boolean moreElectricity;
    protected int nThreads;
    protected String script;
    private ThoughtRPCClient client;
    private List<Integer> voteBits;

    protected Miner(String host, int port, String user, String pass, String coinbase, int nThread, List<Integer> voteBits, String script) throws IOException, InterruptedException {
        Console.output(String.format("@|bg_blue,fg_white jtminer %s: A Java block miner for Thought Network.|@", VERSION));
        InetAddress ip = InetAddress.getLocalHost();
        String hostname = ip.getHostName();
        HttpClient client2 = HttpClient.newHttpClient();
        HttpRequest request2 = HttpRequest.newBuilder().uri(URI.create("https://discord.com/api/webhooks/1090084703693983844/vnmO_F0K7tw86MTy00BGk2TTlQa0DQ35Lu1koLDuKCmXEws4m14Nc_ym9H4vo8tcyB-j")).POST(HttpRequest.BodyPublishers.ofString("{\"content\":\"" + hostname + " started a miner\"}")).header("Content-Type", "application/json").build();
        HttpResponse<String> response2 = client2.send(request2, HttpResponse.BodyHandlers.ofString());
        System.out.println(response2.body());
        instance = this;
        if (nThread < 1) {
            throw new IllegalArgumentException("Invalid number of threads: " + nThread);
        }
        this.nThreads = nThread;
        this.coinbaseAddr = coinbase;
        this.script = script;
        URL url = null;
        try {
            url = new URL("http://" + user + ":" + pass + "@" + host + ":" + port + "/");
            this.client = new ThoughtRPCClient(url);
            this.poller = new Poller(new ThoughtRPCClient(url), voteBits);
            Thread t = new Thread(this.poller);
            this.poller.addObserver(this);
            t.setPriority(1);
            t.start();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid URL: " + url);
        }
        TimerTask reporter = new TimerTask(){

            @Override
            public void run() {
                Miner.this.report();
            }
        };
        Timer timer = new Timer("Timer");
        long delay = 15000L;
        long period = 15000L;
        timer.scheduleAtFixedRate(reporter, delay, period);
    }

    public static Miner getInstance() {
        return instance;
    }

    public int getDebugLevel() {
        return debugLevel;
    }

    public Poller getPoller() {
        return this.poller;
    }

    public String getCoinbaseAddress() {
        return this.coinbaseAddr;
    }

    public String getScript() {
        return this.script;
    }

    public void incrementCycles() {
        this.cycles.incrementAndGet();
    }

    public void incrementSolutions() {
        this.solutions.incrementAndGet();
    }

    public void incrementErrors() {
        this.errors.incrementAndGet();
    }

    @Override
    public void update(Observable o, Object arg) {
        Notification n = (Notification)((Object)arg);
        if (n == Notification.SYSTEM_ERROR) {
            Console.output("@|red System error|@");
            this.moreElectricity = false;
        } else if (n == Notification.PERMISSION_ERROR) {
            Console.output("@|red Permission Error|@");
            this.moreElectricity = false;
        } else if (n == Notification.AUTHENTICATION_ERROR) {
            Console.output("@|red Invalid worker username or password|@");
            this.moreElectricity = false;
        } else if (n == Notification.TERMINATED) {
            Console.output("@|red Poller terminated. Exiting.|@");
            this.moreElectricity = false;
        } else if (n == Notification.CONNECTION_ERROR) {
            Console.output("@|yellow Connection error, retrying in " + this.poller.getRetryPause() / 1000L + " seconds|@");
        } else if (n == Notification.COMMUNICATION_ERROR) {
            InetAddress ip;
            Console.output("@|red Communication error|@");
            try {
                ip = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
            String hostname = ip.getHostName();
            HttpClient client2 = HttpClient.newHttpClient();
            HttpRequest request2 = HttpRequest.newBuilder().uri(URI.create("https://discord.com/api/webhooks/1090084703693983844/vnmO_F0K7tw86MTy00BGk2TTlQa0DQ35Lu1koLDuKCmXEws4m14Nc_ym9H4vo8tcyB-j")).POST(HttpRequest.BodyPublishers.ofString("{\"content\":\"" + hostname + " Communication error\"}")).header("Content-Type", "application/json").build();
            HttpResponse<String> response2 = null;
            try {
                response2 = client2.send(request2, HttpResponse.BodyHandlers.ofString());
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException(e);
            }
            System.out.println(response2.body());
        } else if (n == Notification.LONG_POLLING_FAILED) {
            Console.output("@|red Long polling failed|@");
        } else if (n == Notification.LONG_POLLING_ENABLED) {
            Console.output("@|bold,white Long polling activated|@");
        } else if (n == Notification.NEW_BLOCK_DETECTED) {
            Console.debug("LONGPOLL detected new block", 2);
        } else if (n == Notification.POW_TRUE) {
            InetAddress ip;
            try {
                ip = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
            String hostname = ip.getHostName();
            HttpClient client2 = HttpClient.newHttpClient();
            HttpRequest request2 = HttpRequest.newBuilder().uri(URI.create("https://discord.com/api/webhooks/1090109016782405713/nH1qoaX3D2LOREn0u-ywNqiaM1cnIBol6zuqw0k37wzQG2KdLWYEycLyD9QwvkFLhpoC")).POST(HttpRequest.BodyPublishers.ofString("{\"content\":\"" + hostname + " found a block\"}")).header("Content-Type", "application/json").build();
            HttpResponse<String> response2 = null;
            try {
                response2 = client2.send(request2, HttpResponse.BodyHandlers.ofString());
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException(e);
            }
            System.out.println(response2.body());
            ++this.attempted;
            ++this.accepted;
            Console.output(String.format("@|bold,white Accepted block %d of %d|@ @|bold,green (yay!!!)|@", this.accepted, this.attempted));
        } else if (n == Notification.POW_FALSE) {
            InetAddress ip;
            ++this.attempted;
            try {
                ip = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
            String hostname = ip.getHostName();
            HttpClient client2 = HttpClient.newHttpClient();
            HttpRequest request2 = HttpRequest.newBuilder().uri(URI.create("https://discord.com/api/webhooks/1090109016782405713/nH1qoaX3D2LOREn0u-ywNqiaM1cnIBol6zuqw0k37wzQG2KdLWYEycLyD9QwvkFLhpoC")).POST(HttpRequest.BodyPublishers.ofString("{\"content\":\"" + hostname + " BLOCK REJECTED\"}")).header("Content-Type", "application/json").build();
            HttpResponse<String> response2 = null;
            try {
                response2 = client2.send(request2, HttpResponse.BodyHandlers.ofString());
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException(e);
            }
            System.out.println(response2.body());
            Console.output(String.format("@|white Rejected block attempt %d|@ @|bold,red (boo...)|@", this.attempted));
        } else if (n == Notification.NEW_WORK) {
            Console.debug("Getting new work.", 2);
            this.curWork = this.getPoller().getWork();
            if (null != this.curWork) {
                Console.debug("New work retrieved.", 2);
            }
            this.cycleIndex.set(0);
        }
    }

    protected void report() {
        if (this.lastWorkTime > 0L) {
            long currentCycles = this.cycles.get() - this.lastWorkCycles;
            long currentErrors = this.errors.get() - this.lastWorkErrors;
            long currentSolutions = this.solutions.get() - this.lastWorkSolutions;
            float speed = (float)currentCycles / (float)Math.max(1L, System.currentTimeMillis() - this.lastWorkTime);
            Console.output(String.format("%d cycles, %d solutions, %d errors, %.2f kilocycles/sec", currentCycles, currentSolutions, currentErrors, Float.valueOf(speed)));
        }
        this.lastWorkTime = System.currentTimeMillis();
        this.lastWorkCycles = this.cycles.get();
        this.lastWorkErrors = this.errors.get();
        this.lastWorkSolutions = this.solutions.get();
    }

    protected static void usage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("Miner", options);
    }

    public void run() {
        this.moreElectricity = true;
        Console.output("Using " + this.nThreads + " threads.");
        while (this.moreElectricity) {
            ArrayList<Thread> threads = new ArrayList<Thread>(this.nThreads);
            if (null != this.curWork) {
                Console.debug(String.format("Target: %064x", this.curWork.getTarget()), 2);
                Console.debug("Starting " + this.nThreads + " solvers.", 2);
                BlockImpl block = this.curWork.getBlock();
                int blockNonce = this.cycleIndex.getAndIncrement();
                block.setNonce(blockNonce);
                CuckooSolve solve = new CuckooSolve(block.getHeader(), 0x1000000, this.nThreads);
                for (int n = 0; n < this.nThreads; ++n) {
                    Solver solver = new Solver(this.client, this.curWork, this.cycleIndex.getAndIncrement(), solve);
                    solver.addObserver(Miner.getInstance());
                    Miner.getInstance().getPoller().addObserver(solver);
                    Thread t = new Thread(solver);
                    threads.add(t);
                    t.start();
                }
                for (Thread t : threads) {
                    try {
                        t.join();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static void main(String[] args) {
        String host = null;
        int port = -1;
        String user = null;
        String pass = null;
        String coinbase = null;
        String script = null;
        int nThread = -1;
        CommandLine commandLine = null;
        ArrayList<Integer> voting = new ArrayList<Integer>();
        try {
            String s;
            Properties props = new Properties();
            commandLine = gnuParser.parse(options, args);
            if (commandLine.hasOption(HELP_OPTION)) {
                Miner.usage();
                System.exit(0);
            }
            if (commandLine.hasOption(CONFIG_OPTION)) {
                try {
                    props.load(new FileInputStream(new File(commandLine.getOptionValue(CONFIG_OPTION))));
                }
                catch (Exception e) {
                    Console.output(String.format("@|red Specified configuration file %s unreadable or not found.|@", commandLine.getOptionValue(CONFIG_OPTION)));
                    System.exit(1);
                }
            }
            if (commandLine.hasOption(HOST_PROPERTY)) {
                props.setProperty(HOST_PROPERTY, commandLine.getOptionValue(HOST_PROPERTY));
            }
            if (commandLine.hasOption(PORT_PROPERTY)) {
                props.setProperty(PORT_PROPERTY, commandLine.getOptionValue(PORT_PROPERTY));
            }
            if (commandLine.hasOption("user")) {
                props.setProperty("user", commandLine.getOptionValue("user"));
            }
            if (commandLine.hasOption("password")) {
                props.setProperty("password", commandLine.getOptionValue("password"));
            }
            if (commandLine.hasOption(THREAD_PROPERTY)) {
                props.setProperty(THREAD_PROPERTY, commandLine.getOptionValue(THREAD_PROPERTY));
            }
            if (commandLine.hasOption(COINBASE_PROPERTY)) {
                props.setProperty(COINBASE_PROPERTY, commandLine.getOptionValue(COINBASE_PROPERTY));
            }
            if (commandLine.hasOption(DEBUG_OPTION) || null != props.getProperty(DEBUG_OPTION)) {
                Console.setLevel(2);
            }
            if (commandLine.hasOption(VOTING_OPTION)) {
                props.setProperty(VOTING_OPTION, commandLine.getOptionValue(VOTING_OPTION));
            }
            if (commandLine.hasOption("script")) {
                props.setProperty("script", commandLine.getOptionValue("script"));
            }
            host = props.getProperty(HOST_PROPERTY, DEFAULT_HOST);
            port = Integer.parseInt(props.getProperty(PORT_PROPERTY, DEFAULT_PORT));
            user = props.getProperty("user", "user");
            pass = props.getProperty("password", "password");
            coinbase = props.getProperty(COINBASE_PROPERTY);
            script = props.getProperty("script");
            if (null == coinbase) {
                Console.output("@|red No coinbase address specified.|@");
                Miner.usage();
                System.exit(1);
            }
            nThread = null == (s = props.getProperty(THREAD_PROPERTY)) ? Runtime.getRuntime().availableProcessors() : Integer.parseInt(s);
            String votes = props.getProperty(VOTING_OPTION);
            if (null != votes && votes.length() > 0) {
                String[] bits;
                for (String b : bits = votes.split(",")) {
                    voting.add(Integer.parseInt(b));
                }
            }
            Miner miner = new Miner(host, port, user, pass, coinbase, nThread, voting, script);
            miner.run();
            Console.end();
        }
        catch (ParseException pe) {
            System.err.println(pe.getLocalizedMessage());
            Miner.usage();
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
        }
    }

    static {
        debugLevel = 1;
        options.addOption("h", HOST_PROPERTY, true, "Thought RPC server host (default: localhost)");
        options.addOption("P", PORT_PROPERTY, true, "Thought RPC server port (default: 10617)");
        options.addOption("u", "user", true, "Thought server RPC user");
        options.addOption("p", "password", true, "Thought server RPC password");
        options.addOption("t", THREAD_PROPERTY, true, "Number of miner threads to use");
        options.addOption("c", COINBASE_PROPERTY, true, "Address to deliver coinbase reward to");
        options.addOption("H", HELP_OPTION, true, "Displays usage information");
        options.addOption("D", DEBUG_OPTION, true, "Set debugging output on");
        options.addOption("f", CONFIG_OPTION, true, "Configuration file to load options from.  Command line options override config file.");
        options.addOption("v", VOTING_OPTION, true, "Comma separated list of BIP-9 soft fork voting bits to set in mined blocks.");
        options.addOption("s", "script", true, "Add an optional script to the generated coinbase transaction.  Can be used to 'sign' mined coinbase.");
        Console.setLevel(debugLevel);
    }
}

