/*
 * Decompiled with CFR 0.152.
 */
package live.thought.thought4j;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import live.thought.thought4j.GenericRpcException;
import live.thought.thought4j.ThoughtClientInterface;
import live.thought.thought4j.util.CoinUtil;

public class ThoughtRawTxBuilder {
    public final ThoughtClientInterface thought;
    public Set<ThoughtClientInterface.TxInput> inputs = new LinkedHashSet<ThoughtClientInterface.TxInput>();
    public List<ThoughtClientInterface.TxOutput> outputs = new ArrayList<ThoughtClientInterface.TxOutput>();
    private HashMap<String, ThoughtClientInterface.RawTransaction> txCache = new HashMap();

    public ThoughtRawTxBuilder(ThoughtClientInterface thought) {
        this.thought = thought;
    }

    public ThoughtRawTxBuilder in(ThoughtClientInterface.TxInput in) {
        this.inputs.add(new Input(in.txid(), in.vout()));
        return this;
    }

    public ThoughtRawTxBuilder in(String txid, int vout) {
        this.in(new ThoughtClientInterface.BasicTxInput(txid, vout));
        return this;
    }

    public ThoughtRawTxBuilder out(String address, double amount) {
        if (amount <= 0.0) {
            return this;
        }
        this.outputs.add(new ThoughtClientInterface.BasicTxOutput(address, amount));
        return this;
    }

    public ThoughtRawTxBuilder in(double value) throws GenericRpcException {
        return this.in(value, 6);
    }

    public ThoughtRawTxBuilder in(double value, int minConf) throws GenericRpcException {
        List<ThoughtClientInterface.Unspent> unspent = this.thought.listUnspent(minConf);
        double v = value;
        for (ThoughtClientInterface.Unspent o : unspent) {
            if (!this.inputs.contains(new Input(o))) {
                this.in(o);
                v = CoinUtil.normalizeAmount(v - o.amount());
            }
            if (!(v < 0.0)) continue;
            break;
        }
        if (v > 0.0) {
            throw new GenericRpcException("Not enough bitcoins (" + v + "/" + value + ")");
        }
        return this;
    }

    private ThoughtClientInterface.RawTransaction tx(String txId) throws GenericRpcException {
        ThoughtClientInterface.RawTransaction tx = this.txCache.get(txId);
        if (tx != null) {
            return tx;
        }
        tx = this.thought.getRawTransaction(txId);
        this.txCache.put(txId, tx);
        return tx;
    }

    public ThoughtRawTxBuilder outChange(String address) throws GenericRpcException {
        return this.outChange(address, 0.0);
    }

    public ThoughtRawTxBuilder outChange(String address, double fee) throws GenericRpcException {
        double is = 0.0;
        for (ThoughtClientInterface.TxInput i : this.inputs) {
            is = CoinUtil.normalizeAmount(is + this.tx(i.txid()).vOut().get(i.vout()).value());
        }
        double os = fee;
        for (ThoughtClientInterface.TxOutput o : this.outputs) {
            os = CoinUtil.normalizeAmount(os + o.amount());
        }
        if (os < is) {
            this.out(address, CoinUtil.normalizeAmount(is - os));
        }
        return this;
    }

    public String create() throws GenericRpcException {
        return this.thought.createRawTransaction(new ArrayList<ThoughtClientInterface.TxInput>(this.inputs), this.outputs);
    }

    public String sign() throws GenericRpcException {
        return this.thought.signRawTransaction(this.create(), null, null);
    }

    public String send() throws GenericRpcException {
        return this.thought.sendRawTransaction(this.sign());
    }

    private class Input
    extends ThoughtClientInterface.BasicTxInput {
        private static final long serialVersionUID = 1L;

        public Input(String txid, int vout) {
            super(txid, vout);
        }

        public Input(ThoughtClientInterface.TxInput copy) {
            this(copy.txid(), copy.vout());
        }

        public int hashCode() {
            return this.txid.hashCode() + this.vout;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ThoughtClientInterface.TxInput)) {
                return false;
            }
            ThoughtClientInterface.TxInput other = (ThoughtClientInterface.TxInput)obj;
            return this.vout == other.vout() && this.txid.equals(other.txid());
        }
    }
}

