/*
 * Decompiled with CFR 0.152.
 */
package live.thought.thought4j;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import live.thought.thought4j.GenericRpcException;
import live.thought.thought4j.ThoughtClientInterface;
import live.thought.thought4j.ThoughtPaymentListener;

public class ThoughtAcceptor
implements Runnable {
    private static final Logger logger = Logger.getLogger(ThoughtAcceptor.class.getCanonicalName());
    public final ThoughtClientInterface thought;
    private String lastBlock;
    private String monitorBlock = null;
    int monitorDepth;
    private final LinkedHashSet<ThoughtPaymentListener> listeners = new LinkedHashSet();
    private HashSet<String> seen = new HashSet();
    private boolean stop = false;
    private long checkInterval = 5000L;

    public ThoughtAcceptor(ThoughtClientInterface thought, String lastBlock, int monitorDepth) {
        this.thought = thought;
        this.lastBlock = lastBlock;
        this.monitorDepth = monitorDepth;
    }

    public ThoughtAcceptor(ThoughtClientInterface thought) {
        this(thought, null, 6);
    }

    public ThoughtAcceptor(ThoughtClientInterface thought, String lastBlock, int monitorDepth, ThoughtPaymentListener listener) {
        this(thought, lastBlock, monitorDepth);
        this.listeners.add(listener);
    }

    public ThoughtAcceptor(ThoughtClientInterface thought, ThoughtPaymentListener listener) {
        this(thought, null, 12);
        this.listeners.add(listener);
    }

    public String getAccountAddress(String account) throws GenericRpcException {
        List<String> a = this.thought.getAddressesByAccount(account);
        if (a.isEmpty()) {
            return this.thought.getNewAddress(account);
        }
        return a.get(0);
    }

    public synchronized String getLastBlock() {
        return this.lastBlock;
    }

    public synchronized void setLastBlock(String lastBlock) throws GenericRpcException {
        if (this.lastBlock != null) {
            throw new IllegalStateException("lastBlock already set");
        }
        this.lastBlock = lastBlock;
        this.updateMonitorBlock();
    }

    public synchronized ThoughtPaymentListener[] getListeners() {
        return this.listeners.toArray(new ThoughtPaymentListener[0]);
    }

    public synchronized void addListener(ThoughtPaymentListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeListener(ThoughtPaymentListener listener) {
        this.listeners.remove(listener);
    }

    private void updateMonitorBlock() throws GenericRpcException {
        this.monitorBlock = this.lastBlock;
        for (int i = 0; i < this.monitorDepth && this.monitorBlock != null; ++i) {
            ThoughtClientInterface.Block b = this.thought.getBlock(this.monitorBlock);
            this.monitorBlock = b == null ? null : b.previousHash();
        }
    }

    public synchronized void checkPayments() throws GenericRpcException {
        ThoughtClientInterface.TransactionsSinceBlock t = this.monitorBlock == null ? this.thought.listSinceBlock() : this.thought.listSinceBlock(this.monitorBlock);
        for (ThoughtClientInterface.Transaction transaction : t.transactions()) {
            if (!"receive".equals(transaction.category()) || !this.seen.add(transaction.txId())) continue;
            for (ThoughtPaymentListener listener : this.listeners) {
                try {
                    listener.transaction(transaction);
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            }
        }
        if (!t.lastBlock().equals(this.lastBlock)) {
            this.seen.clear();
            this.lastBlock = t.lastBlock();
            this.updateMonitorBlock();
            for (ThoughtPaymentListener listener : this.listeners) {
                try {
                    listener.block(this.lastBlock);
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public void stopAccepting() {
        this.stop = true;
    }

    public long getCheckInterval() {
        return this.checkInterval;
    }

    public void setCheckInterval(long checkInterval) {
        this.checkInterval = checkInterval;
    }

    @Override
    public void run() {
        this.stop = false;
        long nextCheck = 0L;
        while (!Thread.interrupted() && !this.stop) {
            if (nextCheck <= System.currentTimeMillis()) {
                try {
                    nextCheck = System.currentTimeMillis() + this.checkInterval;
                    this.checkPayments();
                }
                catch (GenericRpcException ex) {
                    Logger.getLogger(ThoughtAcceptor.class.getName()).log(Level.SEVERE, null, ex);
                }
                continue;
            }
            try {
                Thread.sleep(Math.max(nextCheck - System.currentTimeMillis(), 100L));
            }
            catch (InterruptedException ex) {
                Logger.getLogger(ThoughtAcceptor.class.getName()).log(Level.WARNING, null, ex);
            }
        }
    }
}

