/*
 * Decompiled with CFR 0.152.
 */
package live.thought.jtminer.data;

import java.util.ArrayList;
import java.util.List;
import live.thought.jtminer.data.ByteArray;
import live.thought.jtminer.data.DataUtils;
import live.thought.jtminer.data.Hexable;
import live.thought.jtminer.data.PaymentObject;

public class CoinbaseTransaction
implements Hexable {
    protected static final int COINBASE_SCRIPT_LENGTH = 95;
    protected int version = 3;
    protected int type = 5;
    protected long height;
    protected long value;
    protected String address;
    protected List<PaymentObject> extraPayments;
    protected int lockTime = 0;
    protected String extraPayload;
    protected byte[] coinbaseScript;

    public CoinbaseTransaction(long height, long value, String coinbaseAddress) {
        this.height = height;
        this.value = value;
        this.address = coinbaseAddress;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public long getHeight() {
        return this.height;
    }

    public void setHeight(long height) {
        this.height = height;
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long value) {
        this.value = value;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public byte[] getCoinbaseScript() {
        return this.coinbaseScript;
    }

    public void setArbitraryData(byte[] coinbaseScript) {
        this.coinbaseScript = coinbaseScript;
    }

    public void setExtraPayments(List<PaymentObject> extraPayments) {
        this.extraPayments = extraPayments;
    }

    public void addExtraPayment(PaymentObject payment) {
        if (null == this.extraPayments) {
            this.extraPayments = new ArrayList<PaymentObject>();
        }
        this.extraPayments.add(payment);
    }

    public List<PaymentObject> getExtraPayments() {
        return this.extraPayments;
    }

    public int getLockTime() {
        return this.lockTime;
    }

    public void setLockTime(int lockTime) {
        this.lockTime = lockTime;
    }

    public void setExtraPayload(String extraPayload) {
        this.extraPayload = extraPayload;
    }

    public String getExtraPayload() {
        return this.extraPayload;
    }

    public void setCoinbaseScript(byte[] coinbaseScript) {
        this.coinbaseScript = coinbaseScript;
    }

    @Override
    public byte[] getHex() {
        ByteArray cbtx = new ByteArray();
        cbtx.append(DataUtils.hexStringToByteArray(String.format("%04X", Integer.reverseBytes(this.version))), 0, 2);
        cbtx.append(DataUtils.hexStringToByteArray(String.format("%04X", Integer.reverseBytes(this.type))), 0, 2);
        cbtx.append((byte)1);
        byte[] empty = new byte[32];
        cbtx.append(empty);
        byte[] seq = DataUtils.hexStringToByteArray("ffffffff");
        cbtx.append(seq);
        String heightHex = Long.toHexString(this.height);
        byte[] heightBytes = DataUtils.reverseBytes(DataUtils.hexStringToByteArray(heightHex));
        int trailingZeroes = 0;
        if (heightBytes[heightBytes.length - 1] < 0) {
            trailingZeroes = 1;
        }
        int scriptSize = heightBytes.length + trailingZeroes + 1;
        int coinbaseScriptLength = 0;
        if (null != this.coinbaseScript && this.coinbaseScript.length > 0) {
            coinbaseScriptLength = this.coinbaseScript.length > 95 ? 95 : this.coinbaseScript.length;
            scriptSize += coinbaseScriptLength;
        }
        cbtx.append(DataUtils.hexStringToByteArray(String.format("%02X", scriptSize)));
        cbtx.append(DataUtils.hexStringToByteArray(String.format("%02X", heightBytes.length + trailingZeroes)));
        cbtx.append(heightBytes);
        for (int x = 0; x < trailingZeroes; ++x) {
            cbtx.append((byte)0);
        }
        if (coinbaseScriptLength > 0) {
            cbtx.append(this.coinbaseScript, 0, coinbaseScriptLength);
        }
        seq = DataUtils.hexStringToByteArray("00000000");
        cbtx.append(seq);
        int outCounter = 1;
        if (null != this.extraPayments) {
            outCounter += this.extraPayments.size();
        }
        cbtx.append(DataUtils.hexStringToByteArray(String.format("%01X", outCounter)));
        long minerReward = this.value;
        if (null != this.extraPayments) {
            for (PaymentObject p : this.extraPayments) {
                minerReward -= p.getValue();
            }
        }
        byte[] val = DataUtils.hexStringToByteArray(String.format("%016X", Long.reverseBytes(minerReward)));
        cbtx.append(val);
        byte[] addr = DataUtils.addressToScript(this.address);
        byte[] len = DataUtils.encodeCompact(addr.length);
        cbtx.append(len);
        cbtx.append(addr);
        if (null != this.extraPayments) {
            for (PaymentObject p : this.extraPayments) {
                val = DataUtils.hexStringToByteArray(String.format("%016X", Long.reverseBytes(p.getValue())));
                cbtx.append(val);
                addr = DataUtils.addressToScript(p.getPayee());
                len = DataUtils.encodeCompact(addr.length);
                cbtx.append(len);
                cbtx.append(addr);
            }
        }
        byte[] loc = new byte[]{0, 0, 0, 0};
        cbtx.append(loc);
        if (null != this.extraPayload) {
            val = DataUtils.hexStringToByteArray(this.extraPayload);
            len = DataUtils.encodeCompact(val.length);
            cbtx.append(len);
            cbtx.append(val);
        }
        return cbtx.get();
    }
}

