/*
 * Decompiled with CFR 0.152.
 */
package live.thought.jtminer.algo;

import java.nio.charset.Charset;
import org.bouncycastle.crypto.digests.SHA256Digest;

public class SHA256d {
    private SHA256Digest hasher = new SHA256Digest();
    private byte[] digest;
    private int truncate_to;

    public SHA256d(int truncate_to) {
        this.truncate_to = truncate_to > this.hasher.getDigestSize() ? this.hasher.getDigestSize() : truncate_to;
        this.digest = new byte[truncate_to];
    }

    public SHA256d() {
        this.digest = new byte[this.hasher.getDigestSize()];
        this.truncate_to = this.hasher.getDigestSize();
    }

    public void update(String data) {
        this.update(data.getBytes(Charset.forName("UTF-8")));
    }

    public void update(byte[] data) {
        this.hasher.update(data, 0, data.length);
    }

    public byte[] doubleDigest() {
        byte[] h1 = this.getDigest();
        this.update(h1);
        byte[] h2 = this.getDigest();
        System.arraycopy(h2, 0, this.digest, 0, this.truncate_to);
        return this.digest;
    }

    public byte[] digest() {
        byte[] h1 = this.getDigest();
        System.arraycopy(h1, 0, this.digest, 0, this.truncate_to);
        return this.digest;
    }

    private byte[] getDigest() {
        byte[] out = new byte[this.hasher.getDigestSize()];
        this.hasher.doFinal(out, 0);
        return out;
    }
}

