/*
 * Decompiled with CFR 0.152.
 */
package live.thought.jtminer.algo;

import live.thought.jtminer.algo.Edge;
import live.thought.jtminer.algo.SHA256d;

public class Cuckoo {
    public static final int EDGEBITS = 23;
    public static final int NEDGES = 0x800000;
    public static final int NODEBITS = 24;
    public static final int NNODES = 0x1000000;
    public static final int EDGEMASK = 0x7FFFFF;
    public static final int PROOFSIZE = 42;
    long[] k = new long[4];
    SHA256d hasher = new SHA256d(32);

    public static long u8(byte b) {
        return (long)b & 0xFFL;
    }

    public static long u8to64(byte[] p, int i) {
        return Cuckoo.u8(p[i]) | Cuckoo.u8(p[i + 1]) << 8 | Cuckoo.u8(p[i + 2]) << 16 | Cuckoo.u8(p[i + 3]) << 24 | Cuckoo.u8(p[i + 4]) << 32 | Cuckoo.u8(p[i + 5]) << 40 | Cuckoo.u8(p[i + 6]) << 48 | Cuckoo.u8(p[i + 7]) << 56;
    }

    public Cuckoo(byte[] header) {
        this.hasher.update(header);
        byte[] hdrkey = this.hasher.digest();
        this.k[0] = Cuckoo.u8to64(hdrkey, 0);
        this.k[1] = Cuckoo.u8to64(hdrkey, 8);
        this.k[2] = Cuckoo.u8to64(hdrkey, 16);
        this.k[3] = Cuckoo.u8to64(hdrkey, 24);
    }

    public long siphash24(int nonce) {
        long v0 = this.k[0];
        long v1 = this.k[1];
        long v2 = this.k[2];
        long v3 = this.k[3] ^ (long)nonce;
        v0 += v1;
        v2 += v3;
        v1 = v1 << 13 | v1 >>> 51;
        v3 = v3 << 16 | v3 >>> 48;
        v1 ^= v0;
        v3 ^= v2;
        v0 = v0 << 32 | v0 >>> 32;
        v2 += v1;
        v0 += v3;
        v1 = v1 << 17 | v1 >>> 47;
        v3 = v3 << 21 | v3 >>> 43;
        v1 ^= v2;
        v3 ^= v0;
        v2 = v2 << 32 | v2 >>> 32;
        v0 += v1;
        v2 += v3;
        v1 = v1 << 13 | v1 >>> 51;
        v3 = v3 << 16 | v3 >>> 48;
        v1 ^= v0;
        v3 ^= v2;
        v0 = v0 << 32 | v0 >>> 32;
        v2 += v1;
        v0 += v3;
        v1 = v1 << 17 | v1 >>> 47;
        v3 = v3 << 21 | v3 >>> 43;
        v1 ^= v2;
        v3 ^= v0;
        v2 = v2 << 32 | v2 >>> 32;
        v0 ^= (long)nonce;
        v2 ^= 0xFFL;
        v0 += v1;
        v2 += v3;
        v1 = v1 << 13 | v1 >>> 51;
        v3 = v3 << 16 | v3 >>> 48;
        v1 ^= v0;
        v3 ^= v2;
        v0 = v0 << 32 | v0 >>> 32;
        v2 += v1;
        v0 += v3;
        v1 = v1 << 17 | v1 >>> 47;
        v3 = v3 << 21 | v3 >>> 43;
        v1 ^= v2;
        v3 ^= v0;
        v2 = v2 << 32 | v2 >>> 32;
        v0 += v1;
        v2 += v3;
        v1 = v1 << 13 | v1 >>> 51;
        v3 = v3 << 16 | v3 >>> 48;
        v1 ^= v0;
        v3 ^= v2;
        v0 = v0 << 32 | v0 >>> 32;
        v2 += v1;
        v0 += v3;
        v1 = v1 << 17 | v1 >>> 47;
        v3 = v3 << 21 | v3 >>> 43;
        v1 ^= v2;
        v3 ^= v0;
        v2 = v2 << 32 | v2 >>> 32;
        v0 += v1;
        v2 += v3;
        v1 = v1 << 13 | v1 >>> 51;
        v3 = v3 << 16 | v3 >>> 48;
        v1 ^= v0;
        v3 ^= v2;
        v0 = v0 << 32 | v0 >>> 32;
        v2 += v1;
        v0 += v3;
        v1 = v1 << 17 | v1 >>> 47;
        v3 = v3 << 21 | v3 >>> 43;
        v1 ^= v2;
        v3 ^= v0;
        v2 = v2 << 32 | v2 >>> 32;
        v0 += v1;
        v2 += v3;
        v1 = v1 << 13 | v1 >>> 51;
        v3 = v3 << 16 | v3 >>> 48;
        v1 ^= v0;
        v3 ^= v2;
        v0 = v0 << 32 | v0 >>> 32;
        v2 += v1;
        v0 += v3;
        v1 = v1 << 17 | v1 >>> 47;
        v3 = v3 << 21 | v3 >>> 43;
        v1 ^= v2;
        v2 = v2 << 32 | v2 >>> 32;
        return v0 ^ v1 ^ (v2 ^ (v3 ^= v0));
    }

    public int sipnode(int nonce, int uorv) {
        return (int)this.siphash24(2 * nonce + uorv) & 0x7FFFFF;
    }

    public Edge sipedge(int nonce) {
        return new Edge(this.sipnode(nonce, 0), this.sipnode(nonce, 1));
    }

    public Boolean verify(int[] nonces, int easiness) {
        int n;
        int[] us = new int[42];
        int[] vs = new int[42];
        int i = 0;
        int xor0 = 0;
        int xor1 = 0;
        for (n = 0; n < 42; ++n) {
            if (nonces[n] >= easiness || n != 0 && nonces[n] <= nonces[n - 1]) {
                return false;
            }
            us[n] = this.sipnode(nonces[n], 0);
            vs[n] = this.sipnode(nonces[n], 1);
            xor0 ^= us[n];
            xor1 ^= vs[n];
        }
        if (xor0 > 0 || xor1 > 0) {
            return false;
        }
        do {
            int k;
            int j = i;
            for (k = 0; k < 42; ++k) {
                if (k == i || vs[k] != vs[i]) continue;
                if (j != i) {
                    return false;
                }
                j = k;
            }
            if (j == i) {
                return false;
            }
            i = j;
            for (k = 0; k < 42; ++k) {
                if (k == j || us[k] != us[j]) continue;
                if (i != j) {
                    return false;
                }
                i = k;
            }
            if (i == j) {
                return false;
            }
            n -= 2;
        } while (i != 0);
        return n == 0;
    }
}

