/*
 * Decompiled with CFR 0.152.
 */
package live.thought.jtminer;

import java.io.IOException;
import java.security.AccessControlException;
import java.util.List;
import java.util.Observable;
import java.util.concurrent.atomic.AtomicBoolean;
import live.thought.jtminer.Notification;
import live.thought.jtminer.Work;
import live.thought.jtminer.data.BlockImpl;
import live.thought.jtminer.util.Console;
import live.thought.thought4j.ThoughtClientInterface;

public class Poller
extends Observable
implements Runnable {
    protected long retryPause = 10000L;
    protected ThoughtClientInterface client;
    protected AtomicBoolean moreElectricity = new AtomicBoolean(false);
    protected Work currentWork = null;
    protected long currentHeight = 0L;
    protected int[] workMutex = new int[0];
    protected List<Integer> voteBits;

    public Poller(ThoughtClientInterface client) {
        this.client = client;
    }

    public Poller(ThoughtClientInterface client, List<Integer> voteBits) {
        this.client = client;
        this.voteBits = voteBits;
    }

    public synchronized void shutdown() {
        this.moreElectricity.set(false);
        this.notifyAll();
    }

    public synchronized Work getWork() {
        Work retval = null;
        retval = this.currentWork;
        return retval;
    }

    public long getRetryPause() {
        return this.retryPause;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        Console.debug("Starting poller.", 2);
        this.moreElectricity.set(true);
        boolean notified = false;
        ThoughtClientInterface.BlockTemplate bl = null;
        String longpollid = null;
        while (this.moreElectricity.get()) {
            try {
                bl = this.client.getBlockTemplate(longpollid);
                longpollid = bl.longpollid();
                if (null != bl.longpollid()) {
                    if (!notified) {
                        this.setChanged();
                        this.notifyObservers((Object)Notification.LONG_POLLING_ENABLED);
                        notified = true;
                    }
                    if (bl.height() <= this.currentHeight) continue;
                    this.setChanged();
                    this.notifyObservers((Object)Notification.NEW_BLOCK_DETECTED);
                    Console.output(String.format("@|cyan Current block is %d|@", bl.height()));
                    Work w = new Work(bl);
                    if (null != this.voteBits) {
                        BlockImpl b = w.getBlock();
                        for (int i : this.voteBits) {
                            b.addVoteBit(i);
                        }
                    }
                    int[] nArray = this.workMutex;
                    // MONITORENTER : this.workMutex
                    this.currentWork = w;
                    this.currentHeight = bl.height();
                    // MONITOREXIT : nArray
                    this.setChanged();
                    this.notifyObservers((Object)Notification.NEW_WORK);
                    continue;
                }
                this.setChanged();
                this.notifyObservers((Object)Notification.LONG_POLLING_FAILED);
            }
            catch (Exception e) {
                this.setChanged();
                if (e instanceof IllegalArgumentException) {
                    this.notifyObservers((Object)Notification.AUTHENTICATION_ERROR);
                    this.shutdown();
                    return;
                }
                if (e instanceof AccessControlException) {
                    this.notifyObservers((Object)Notification.PERMISSION_ERROR);
                    this.shutdown();
                    return;
                }
                if (e instanceof IOException) {
                    this.notifyObservers((Object)Notification.CONNECTION_ERROR);
                } else {
                    this.notifyObservers((Object)Notification.COMMUNICATION_ERROR);
                }
                try {
                    this.currentWork = null;
                    Thread.sleep(this.retryPause);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

