/*
 * Decompiled with CFR 0.152.
 */
package live.thought.jtminer.data;

import java.util.ArrayList;
import java.util.List;
import live.thought.jtminer.algo.SHA256d;
import live.thought.jtminer.data.CoinbaseTransaction;
import live.thought.jtminer.data.DataUtils;
import live.thought.jtminer.data.TransactionImpl;

public class MerkleTree {
    private SHA256d hasher;
    ArrayList<byte[]> tree = new ArrayList();

    public MerkleTree(CoinbaseTransaction cbtx, List<TransactionImpl> transactions) {
        int treeSize;
        this.hasher = new SHA256d(32);
        byte[] data = new byte[64];
        this.hasher.update(cbtx.getHex());
        byte[] cbtxHash = DataUtils.reverseBytes(this.hasher.doubleDigest());
        this.tree.add(cbtxHash);
        for (TransactionImpl t : transactions) {
            this.hasher.update(t.getHex());
            this.tree.add(DataUtils.reverseBytes(this.hasher.doubleDigest()));
        }
        int levelOffset = 0;
        int levelSize = treeSize = transactions.size() + 1;
        while (levelSize > 1) {
            for (int left = 0; left < levelSize; left += 2) {
                int right = Math.min(left + 1, levelSize - 1);
                byte[] leftBytes = DataUtils.reverseBytes(this.tree.get(levelOffset + left));
                byte[] rightBytes = DataUtils.reverseBytes(this.tree.get(levelOffset + right));
                System.arraycopy(leftBytes, 0, data, 0, 32);
                System.arraycopy(rightBytes, 0, data, 32, 32);
                this.hasher.update(data);
                this.tree.add(DataUtils.reverseBytes(this.hasher.doubleDigest()));
            }
            levelOffset += levelSize;
            levelSize = (levelSize + 1) / 2;
        }
    }

    public byte[] getRoot() {
        return this.tree.get(this.tree.size() - 1);
    }
}

