/*
 * Decompiled with CFR 0.152.
 */
package live.thought.jtminer.util;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class Logger {
    private static boolean loggingEnabled = false;
    private static final DateTimeFormatter FILE_DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter LOG_TIMESTAMP_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final String INSTANCE_ID = String.format("%06X", (int)(Math.random() * 1.6777215E7));
    private static final String LOG_FILE_PREFIX = "Log-";
    private static final String LOG_FILE_EXTENSION = ".txt";

    public static void setLoggingEnabled(boolean enabled) {
        loggingEnabled = enabled;
        if (enabled) {
            Logger.log("Logging system enabled with instance ID: " + INSTANCE_ID);
        }
    }

    public static boolean isLoggingEnabled() {
        return loggingEnabled;
    }

    public static String getInstanceId() {
        return INSTANCE_ID;
    }

    public static void log(String information) {
        if (!loggingEnabled) {
            return;
        }
        if (information == null) {
            information = "null";
        }
        LocalDateTime now = LocalDateTime.now();
        String fileName = Logger.generateLogFileName(now);
        String logEntry = Logger.formatLogEntry(now, information);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(fileName, true));){
            writer.write(logEntry);
            writer.newLine();
            writer.flush();
        }
        catch (IOException e) {
            System.err.println("Erreur lors de l'\u00e9criture du log: " + e.getMessage());
            System.err.println("Message original: " + information);
        }
    }

    private static String generateLogFileName(LocalDateTime dateTime) {
        return LOG_FILE_PREFIX + dateTime.format(FILE_DATE_FORMAT) + "-" + INSTANCE_ID + LOG_FILE_EXTENSION;
    }

    private static String formatLogEntry(LocalDateTime dateTime, String information) {
        return dateTime.format(LOG_TIMESTAMP_FORMAT) + " - " + information;
    }
}

