/*
 * Decompiled with CFR 0.152.
 */
package live.thought.jtminer.algo;

import java.util.HashSet;
import live.thought.jtminer.algo.Cuckoo;
import live.thought.jtminer.algo.Edge;

public class CuckooSolve {
    public static final int MAXPATHLEN = 4096;
    Cuckoo graph;
    int easiness;
    int[] cuckoo;
    int nthreads;
    private HashSet<Edge> solutionCycle;
    private int[] solutionArray;
    private static final int MAXPATH_CHECK = 4092;

    public CuckooSolve(byte[] hdr, int en, int nt) {
        this.graph = new Cuckoo(hdr);
        this.easiness = en;
        this.cuckoo = new int[0x1000001];
        assert (this.cuckoo != null);
        this.nthreads = nt;
    }

    public int path(int u, int[] us) {
        int nu = 0;
        while (u != 0) {
            us[++nu] = u;
            u = this.cuckoo[u];
            if (nu < 4092) continue;
            int i = nu;
            while (i-- != 0 && us[i] != u) {
            }
            throw new RuntimeException((String)(i < 0 ? "maximum path length exceeded" : "illegal " + (nu - i) + "-cycle"));
        }
        return nu;
    }

    public synchronized int[] solution(int[] us, int nu, int[] vs, int nv) {
        if (this.solutionCycle == null) {
            this.solutionCycle = new HashSet(84);
            this.solutionArray = new int[42];
        } else {
            this.solutionCycle.clear();
        }
        this.solutionCycle.add(new Edge(us[0], vs[0] - 0x800000));
        int nuOriginal = nu;
        while (nu-- != 0) {
            this.solutionCycle.add(new Edge(us[nu + 1 & 0xFFFFFFFE], us[nu | 1] - 0x800000));
        }
        int nvOriginal = nv;
        while (nv-- != 0) {
            this.solutionCycle.add(new Edge(vs[nv | 1], vs[nv + 1 & 0xFFFFFFFE] - 0x800000));
        }
        Edge e = null;
        int n = 0;
        for (int nonce = 0; nonce < this.easiness && n < 42; ++nonce) {
            e = this.graph.sipedge(nonce);
            if (!this.solutionCycle.contains(e)) continue;
            this.solutionArray[n++] = nonce;
            this.solutionCycle.remove(e);
        }
        return n == 42 ? this.solutionArray : null;
    }

    public int getEasiness() {
        return this.easiness;
    }

    public int[] getCuckoo() {
        return this.cuckoo;
    }

    public int getNthreads() {
        return this.nthreads;
    }

    public Cuckoo getGraph() {
        return this.graph;
    }

    public void cleanup() {
        this.graph = null;
        this.cuckoo = null;
    }
}

